<?php
/* Copyright (C) 2025 Florian SuperAdmin <florian.dufourg@gnl-solutions.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    smartbankimport/lib/smartbankimport.lib.php
 * \ingroup smartbankimport
 * \brief   Library files with common functions for SmartBankImport
 */

/**
 * Prepare admin pages header
 *
 * @return array
 */
function smartbankimportAdminPrepareHead()
{
	global $langs, $conf;

	$langs->load("smartbankimport@smartbankimport");

	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath("/smartbankimport/admin/setup.php", 1);
	$head[$h][1] = $langs->trans("Settings");
	$head[$h][2] = 'settings';
	$h++;

	/*
	$head[$h][0] = dol_buildpath("/smartbankimport/admin/myobject_extrafields.php", 1);
	$head[$h][1] = $langs->trans("ExtraFields");
	$nbExtrafields = is_countable($extrafields->attributes['myobject']['label']) ? count($extrafields->attributes['myobject']['label']) : 0;
	if ($nbExtrafields > 0) {
		$head[$h][1] .= ' <span class="badge">' . $nbExtrafields . '</span>';
	}
	$head[$h][2] = 'myobject_extrafields';
	$h++;
	*/

	$head[$h][0] = dol_buildpath("/smartbankimport/admin/about.php", 1);
	$head[$h][1] = $langs->trans("About");
	$head[$h][2] = 'about';
	$h++;

	// Show more tabs from modules
	// Entries must be declared in modules descriptor with line
	//$this->tabs = array(
	//	'entity:+tabname:Title:@smartbankimport:/smartbankimport/mypage.php?id=__ID__'
	//); // to add new tab
	//$this->tabs = array(
	//	'entity:-tabname:Title:@smartbankimport:/smartbankimport/mypage.php?id=__ID__'
	//); // to remove a tab
	complete_head_from_modules($conf, $langs, null, $head, $h, 'smartbankimport@smartbankimport');

	complete_head_from_modules($conf, $langs, null, $head, $h, 'smartbankimport@smartbankimport', 'remove');

	return $head;
}



function getEnableBankingJwtString($rsa_key, $appId, $expTimeSec = 3600) {
    // 1. Create the Header
    $header = json_encode(['typ' => 'JWT', 'alg' => 'RS256', 'kid' => $appId]);
    
    // 2. Create the Payload
    $payload = json_encode([
        'iss' => 'enablebanking.com',
        'aud' => 'api.enablebanking.com',
        'iat' => time(),
        'exp' => time() + $expTimeSec
    ]);

    // 3. Base64Url Encode Header and Payload
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

    // 4. Create Signature
    $signatureInput = $base64UrlHeader . "." . $base64UrlPayload;
    $signature = '';
    
    // This uses the native PHP OpenSSL extension
    openssl_sign($signatureInput, $signature, $rsa_key, OPENSSL_ALGO_SHA256);

    // 5. Base64Url Encode Signature
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

    // 6. Combine all parts
    return $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
}