<?php
/* Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2015 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2015      Jean-François Ferry	<jfefe@aternatik.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       smartbankimport/smartbankimportindex.php
 *	\ingroup    smartbankimport
 *	\brief      Home page of smartbankimport top menu
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME']; $tmp2 = realpath(__FILE__); $i = strlen($tmp) - 1; $j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--;
	$j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1))."/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1))."/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) {
	$res = @include "../main.inc.php";
}
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}

//Access forbidden include top menu
if(!$user->hasRight('smartbankimport', 'write')){
	accessforbidden('Activate SmartBankImport right to read for user : '.$user->login);
}


/*
 * View
 */

$conf->dol_hide_leftmenu = 1;
//llxHeader($head = '', $title = '', $help_url = '', $target = '', $disablejs = 0, $disablehead = 0, $arrayofjs = '', $arrayofcss = '', $morequerystring = '', $morecssonbody = '', $replacemainareaby = '', $disablenofollow = 0, $disablenoindex = 0)
$head = '';
$title = '';
$help_url = '';
$target = '';
$disablejs = 0;
$disablehead = 0;
$arrayofjs = '';
$arrayofcss = '';
$morequerystring = '';
$morecssonbody = '';
$replacemainareaby = '<div>';
$disablenofollow = 0;
$disablenoindex = 0;
llxHeader($head, $title, $help_url, $target, $disablejs, $disablehead, $arrayofjs, $arrayofcss, $morequerystring, $morecssonbody, $replacemainareaby, $disablenofollow, $disablenoindex);


if(isset($conf->global->SMARTBANKIMPORT_SCREEN_HEIGHT)){
	$paramScreenHeight = $conf->global->SMARTBANKIMPORT_SCREEN_HEIGHT;
}else{
	$paramScreenHeight = 0;
}

if(isset($conf->global->SMARTBANKIMPORT_SCREEN_WIDTH)){
	$paramScreenHeight = $conf->global->SMARTBANKIMPORT_SCREEN_WIDTH;
}else{
	$paramScreenHeight = 0;
}

if(empty($conf->modules["api"])){
	print "ERROR : Activate module REST API";


}else{

	$host = $_SERVER['HTTP_HOST'];

	if(substr($host,0,4) != "http"){
		if($_SERVER['HTTPS'] == "on"){
			$dolibarr_domain = "https://".$host;
		}else{
			$dolibarr_domain = "http://".$host;
		}
		
	}else{
		$dolibarr_domain = $host;
	}


	$url = "https://app.smartbankimport.com/?dolibarr_domain=".urlencode($dolibarr_domain)."&dolibarr_token=".$user->api_key;

	//$url = "http://localhost:8081?dolibarr_domain=".urlencode($dolibarr_domain)."&dolibarr_token=".$user->api_key;

	print '<iframe id="iFrame1" title="BANKIMPORT" width="99%" height="900" src="'.$url.'"></iframe>';

}

?>
<script type="application/javascript">

	function resizeIFrameToFitContent( iFrame ) {

		const paramScreenHeight = <?php echo $paramScreenHeight; ?>;
		const paramScreenWidth = <?php echo $paramScreenWidth; ?>;


		iFrame.width  = paramScreenWidth > 0 ? paramScreenWidth : iFrame.contentWindow.document.body.scrollWidth;
		iFrame.height = paramScreenHeight > 0 ? paramScreenHeight : iFrame.contentWindow.document.body.scrollHeight - 80;
	}

	window.addEventListener('DOMContentLoaded', function(e) {

		var iFrame = document.getElementById( 'iFrame1' );
		resizeIFrameToFitContent( iFrame );

	} );

</script>

<?php
llxFooter();
